hs.ipc.cliInstall()

-- Tidal Media Controls
function tidalPlayPause()
    local tidal = hs.application.find("TIDAL")
    if tidal then
        tidal:selectMenuItem({"Playback", "Play/Pause"})
        if not tidal:selectMenuItem({"Playback", "Play/Pause"}) then
            hs.eventtap.keyStroke({}, "space", 0, tidal)
        end
    end
    hs.timer.doAfter(0.3, function()
        updateTidalBTTVariable()
        updateTidalTrackInfo()
    end)
end

function tidalNext()
    local tidal = hs.application.find("TIDAL")
    if tidal then
        tidal:selectMenuItem({"Playback", "Next"})
        if not tidal:selectMenuItem({"Playback", "Next"}) then
            hs.eventtap.keyStroke({"cmd"}, "right", 0, tidal)
        end
    end
    hs.timer.doAfter(0.3, updateTidalTrackInfo)
end

function tidalPrevious()
    local tidal = hs.application.find("TIDAL")
    if tidal then
        tidal:selectMenuItem({"Playback", "Previous"})
        if not tidal:selectMenuItem({"Playback", "Previous"}) then
            hs.eventtap.keyStroke({"cmd"}, "left", 0, tidal)
        end
    end
    hs.timer.doAfter(0.3, updateTidalTrackInfo)
end

-- Check if Tidal is playing (returns 1 if playing, 0 if not)
function tidalIsPlaying()
    local tidal = hs.application.find("TIDAL")
    if not tidal then
        return 0
    end
    
    local success, menuItems = pcall(function()
        return tidal:findMenuItem({"Playback", "Pause"})
    end)
    
    if success and menuItems and menuItems.enabled then
        return 1  -- playing
    end
    
    return 0  -- paused or stopped
end

-- Update BTT variable using AppleScript
function updateTidalBTTVariable()
    local state = tidalIsPlaying()
    os.execute(string.format([[osascript -e 'tell application "BetterTouchTool" to set_persistent_string_variable "customVariable1" to "%d"']], state))
end

-- Truncate string to max length with ellipsis
function truncateString(str, maxLen)
    if not str then return "" end
    if #str <= maxLen then return str end
    return str:sub(1, maxLen - 1) .. "…"
end

-- Get current track info from Tidal
function getTidalTrackInfo()
    local tidal = hs.application.find("TIDAL")
    if not tidal then
        return nil
    end
    
    -- Get track info from the actual window, not the app title
    local windows = tidal:allWindows()
    for _, win in ipairs(windows) do
        local winTitle = win:title()
        -- Skip empty titles and the generic "TIDAL" title
        if winTitle and winTitle ~= "TIDAL" and winTitle ~= "" then
            -- Truncate to 30 characters
            return truncateString(winTitle, 30)
        end
    end
    
    return nil
end

-- Update BTT with track info
function updateTidalTrackInfo()
    local trackInfo = getTidalTrackInfo()
    local state = tidalIsPlaying()
    
    local displayText = ""
    if trackInfo and state == 1 then
        displayText = trackInfo
    elseif state == 1 then
        displayText = "Playing..."
    else
        displayText = ""
    end
    
    -- Better escaping for AppleScript
    local escaped = displayText:gsub("\\", "\\\\"):gsub('"', '\\"'):gsub("\n", "\\n")
    
    -- Set the variable
    os.execute(string.format([[osascript -e 'tell application "BetterTouchTool" to set_persistent_string_variable "tidal_track" to "%s"']], escaped))
end

-- Bring Tidal to front when clicked
function showTidal()
    local tidal = hs.application.find("TIDAL")
    if tidal then
        tidal:activate()
    end
end

-- Monitor Tidal state every 2 seconds
if tidalMonitor then tidalMonitor:stop() end
tidalMonitor = hs.timer.doEvery(2, function()
    updateTidalBTTVariable()
    updateTidalTrackInfo()
end)

-- Set initial states
updateTidalBTTVariable()
updateTidalTrackInfo()